#include <algorithm>
#include <set>
#include <iostream>
#include <vector>

using namespace std;

int t, r;
const int MAX = 24 * 3600;
int sekunde[MAX];
set<pair<int, int> > najveci, najmanji;

void ucitaj_podatke() {
	int n;
	cin >> n >> t >> r;
	vector<int> dolasci, odlasci;
	dolasci.resize(n);
	odlasci.resize(n);
	for (int i = 0; i < n; ++i) {
		int sat, minuta, sekunda, koliko;
		cin >> sat >> minuta >> sekunda >> koliko;
		dolasci[i] = sekunda + 60 * (minuta + 60 * sat);
		odlasci[i] = dolasci[i] + koliko;
	}
	sort(dolasci.begin(), dolasci.end());
	sort(odlasci.begin(), odlasci.end());
	int d_poz = 0, o_poz = 0, trenutno = 0;
	for (int i = 0; i < MAX; ++i) {
		while (d_poz < n && dolasci[d_poz] < i) ++d_poz;
		while (o_poz < n && odlasci[o_poz] < i) ++o_poz;
		while (d_poz < n && dolasci[d_poz] == i) {
			++trenutno;
			++d_poz;
		}
		while (o_poz < n && odlasci[o_poz] == i) {
			--trenutno;
			++o_poz;
		}
		sekunde[i] = trenutno;
	}
}

int rijesi() {
	int zbroj_najvecih = 0;
	for (int i = 1; i < t - 1; ++i) {
		zbroj_najvecih += sekunde[i];
		najveci.insert(make_pair(sekunde[i], i));
	}
	for (int i = 0; i < r; ++i) {
		pair<int, int> dno = *najveci.begin();
		najveci.erase(najveci.begin());
		najmanji.insert(dno);
		zbroj_najvecih -= dno.first;
	}
	int maksimalan_zbroj = zbroj_najvecih + sekunde[0] + sekunde[t - 1], rjesenje = 0;
	for (int i = t; i < MAX; ++i) {
		pair<int, int> par_lijevo(sekunde[i - t + 1], i - t + 1);
		pair<int, int> par_desno(sekunde[i - 1], i - 1);
		if (r < t - 2 && par_lijevo >= *najveci.begin()) {
			najveci.erase(najveci.find(par_lijevo));
			najveci.insert(par_desno);
			zbroj_najvecih += -sekunde[i - t + 1] + sekunde[i - 1];
		} else if (r > 0) {
			najmanji.erase(najmanji.find(par_lijevo));
			najmanji.insert(par_desno);
		}
		if (r > 0 && r < t - 2) {
			pair<int, int> dno = *najveci.begin(), vrh = *najmanji.rbegin();
			if (dno < vrh) {
				najveci.erase(najveci.begin());
				najmanji.erase(najmanji.find(vrh));
				najveci.insert(vrh);
				najmanji.insert(dno);
				zbroj_najvecih += vrh.first - dno.first;
			}
		}
		int zbroj = zbroj_najvecih + sekunde[i - t + 1] + sekunde[i];
		if (zbroj > maksimalan_zbroj) {
			maksimalan_zbroj = zbroj;
			rjesenje = i - t + 1;
		}
	}
	return rjesenje;
}

int main() {
	ucitaj_podatke();
	int rjesenje = rijesi();
	cout << rjesenje / 3600 << " " << (rjesenje % 3600) / 60 << " " << rjesenje % 60 << endl;
	return 0;
}
